%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Solving Lorenz-96 model with Runge-Kutta Method
% Created by Tyrus Berry, edited by John Harlim
% Last edited: March 14, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function u = l96rk4(Z1,Z2,u0,T)

N = size(u0,1);
dt = .05;

u = zeros(N,T);
u(:,1) = u0;


for i = 1:T
    k1 = l96rhs(u(:,i),Z1,Z2);
    y1 = u(:,i) + k1*dt/2;
    k2 = l96rhs(y1,Z1,Z2);
    y2 = u(:,i) + k2*dt/2;
    k3 = l96rhs(y2,Z1,Z2);
    y3 = u(:,i) + k3*dt;
    k4 = l96rhs(y3,Z1,Z2);
    u(:,i+1) = u(:,i) + (k1+2*k2+2*k3+k4)*dt/6;

end


function f = l96rhs(u,theta1,theta2)

f = circshift(u,[1 0]).*(circshift(u,[-1 0])-circshift(u,[2 0]))-theta1*u+theta2;

